﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        Mod3 wert;
        CheckBox[] boxes;

        public Form1()
        {
            InitializeComponent();
            boxes = new CheckBox[] { checkBox1, checkBox2, checkBox3 };
            wert = 0;//Wir haben den impliziten Cast festgelegt - dies geht also!

            //Sobald wir einen CheckBox Haken ändern, soll dies Auswirkungen auf die Mod3 Instanz haben
            for (int i = 0; i < boxes.Length; i++)
            {
                boxes[i].Tag = i;
                boxes[i].CheckedChanged += new EventHandler(c_CheckedChanged);
            }

            //Sobald sich der Wert ändert soll ein Event ausgelöst werden
            wert.ValueChanged += new EventHandler(wert_ValueChanged);
        }

        //Hier ändern wir über unseren Indexoperator den Wert
        private void c_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox c = sender as CheckBox;
            wert[(int)c.Tag] = c.Checked;
//            numericUpDown1.Value = wert.Value;
        }

        //Das wir hier abfangen und benutzen um die Textbox zu setzen
        //und die Werte der Checkboxen
        private void wert_ValueChanged(object sender, EventArgs e)
        {
            textBox1.Text = sender.ToString();

            //Auslesen des Indexoperators
            for (int i = 0; i < boxes.Length; i++)
                boxes[i].Checked = wert[i];
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            wert.Value = (int)numericUpDown1.Value;
            calculate();
        }

        private void numericUpDown2_ValueChanged(object sender, EventArgs e)
        {
            calculate();
        }

        private void calculate()
        {
            //Es ist also eine Mod3 * int operation.
            //=> Dies ist nicht festgelegt, daher wird geschaut ob ein impliziter Cast festgelegt ist,
            //   so dass diese Operation geht. In der Tat haben wir int -> Mod3 festlegt und
            //   ebenso Mod3 * Mod3
            numericUpDown3.Value = (int)(new Mod3((int)numericUpDown1.Value) * (int)numericUpDown2.Value);
        }
    }
}
